package cmd

import (
	"fmt"
	"log"
	"net/http"
	"net/http/cookiejar"
	"net/url"
	"strings"
	"time"
)

// CheckAvailableCountry 判断当前区域能否播放指定的netflix url
func CheckAvailableCountry(cookies []*http.Cookie, netflixUrl, ProxyOnOff, proxyUrl string) (bool, error) {
	var err error
	transport := &http.Transport{}

	//是否使用代码的开关
	if ProxyOnOff == "on" {
		//根据参数判断是否需要设置proxy
		proxy, err := url.Parse(proxyUrl)
		if err != nil {
			log.Printf("proxy url parse error : %v \n", err)
			return false, err
		}
		transport.Proxy = http.ProxyURL(proxy)
	}

	//new个cookiejar罐子
	jar, err := cookiejar.New(nil)

	if err != nil {
		log.Printf("cookiejar New error : %v\n", err)
		return false, err
	}

	//原生的url,orz
	parseUrl, err := url.Parse(netflixUrl)
	if err != nil {
		log.Printf("netflixUrl Parse error : %v\n", err)
	}
	//fmt.Printf("parseUrl===>%v\n", parseUrl)
	//把传入的cookies装入罐
	jar.SetCookies(parseUrl, cookies)

	//初始化请求
	client := &http.Client{Jar: jar, Transport: transport, Timeout: 15 * time.Second}
	req, _ := http.NewRequest("GET", netflixUrl, nil)

	//请求加入头部
	req.Header.Add("User-Agent", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/94.0.4606.81 Safari/537.36")

	// todo 检测跳转
	//client.CheckRedirect = func(req *http.Request, via []*http.Request) error {
	//	println(len(via))
	//	return http.ErrUseLastResponse
	//}

	//发出请求
	resp, err := client.Do(req)
	defer func() {
		if err1 := recover(); err1 != nil {
			XWarning(fmt.Sprintf("connect to the netflix faild %v\n", err1))
			err = fmt.Errorf("connect to the netflix faild %v\n", err1)
		}
	}()
	if err != nil {
		XWarning(fmt.Sprintf("client.Do error : %v\n", err))
		return false, err
	}

	//根据response的url是否包含某些字符串,判断是否跳转
	if strings.Contains(resp.Request.URL.RequestURI(), "/watch/0") == true {
		return false, nil
	}
	defer resp.Body.Close()
	return true, nil

}
