package cmd

import (
	"fmt"
	"image"
	"image/gif"
	"image/jpeg"
	"image/png"
	"log"
	"os"
	"strings"
)

// @title   LoadImage
// @description    读取图片内容
// @param
// @return

func LoadImage(imgPath string) (image.Image, error) {
	var img image.Image
	var err error

	f, err := os.Open(imgPath)
	if err != nil {
		log.Printf("os.Open error : %v\n", err)
		return nil, err
	}
	defer f.Close()

	if strings.HasSuffix(imgPath, "jpg") || strings.HasSuffix(imgPath, "jpeg") {
		img, err = jpeg.Decode(f)
	} else if strings.HasSuffix(imgPath, "png") {
		img, err = png.Decode(f)
	} else if strings.HasSuffix(imgPath, "gif") {
		img, err = gif.Decode(f)
	} else {
		return nil, fmt.Errorf("当前图片格式不支持")
	}

	return img, err
}

// @title    WriteImage
// @description    image数据写入图片文件
// @param
// @return

func WriteImage(imgPath string, imgData *image.RGBA) error {

	//打开新新图片文件
	f, err := os.Create(imgPath)
	if err != nil {
		log.Printf("%v, Create error : %v\n", imgPath, err)
		return err
	}
	defer f.Close()

	//写入图片文件
	png.Encode(f, imgData)
	return err

}

// @title TrimImg
// @description 裁剪图片,去除四周空白部分
// @param
// @return

func TrimImg(imgPath, subImgPath string) error {
	img, err := LoadImage(imgPath)
	if err != nil {
		log.Printf("LoadImage  error : %v\n", err)
		return err
	}

	bounds := img.Bounds()
	width, height := bounds.Max.X, bounds.Max.Y
	fmt.Printf("width,height=============>%v,%v\n", width, height)
	var x, y int
	var wx, wy int //切割点的x和y
	//遍历宽
	for x = 0; x < width; x++ {
		//遍历高
		for y = 0; y < height; y++ {
			r, g, b, _ := img.At(x, y).RGBA()
			//fmt.Printf("r,g,b========>%v,%v,%v\n", int(r/257), int(g/257), int(b/257))
			//判断当前坐标是否大于切割点坐标 , todo 为啥要除以257呢?
			if int(r/257) < 255 && int(g/257) < 255 && int(b/257) < 255 && x >= wx && y >= wy {
				wx = x
				wy = y
			}
		}
	}
	fmt.Printf("wx,wy===========>%v,%v\n", wx, wy)
	rgbImg := img.(*image.RGBA)

	subImg := rgbImg.SubImage(image.Rect(0, 0, wx, wy)).(*image.RGBA)

	WriteImage(subImgPath, subImg)
	//fmt.Printf("%v %v %v\n", r, g, b)
	//
	//hex:=fmt.Sprintf("%s%s%s",
	//	t2x(int64(r)),
	//	t2x(int64(g)),
	//	t2x(int64(b)),
	//	)
	//println(hex)
	return nil
}
