package ocr

import (
	"fmt"
	"github.com/sirupsen/logrus"
	"io/ioutil"
	"os"
	"os/exec"
	"path/filepath"
	"strings"
)

func OCRPlus(rawPath string, lang string, psm string, stepList []string) (output string, err error) {

	exePath, err := exec.LookPath("tesseract.exe")
	if err != nil {
		return output, err
	}

	ocr, err := filepath.Abs(exePath)
	if err != nil {
		return output, err
	}

	processedPath, err := ProcessImage(rawPath, stepList)

	rawDir, rawFileName := filepath.Split(rawPath)
	rawExt := filepath.Ext(rawFileName)
	outputPath := filepath.Join(rawDir, fmt.Sprintf("%s", rawFileName[:len(rawFileName)-len(rawExt)]))
	outputPath2 := filepath.Join(rawDir, fmt.Sprintf("%s.txt", rawFileName[:len(rawFileName)-len(rawExt)]))
	processedPath = filepath.ToSlash(processedPath)
	outputPath = filepath.ToSlash(outputPath)
	args := []string{processedPath, outputPath, "-l", lang, "--psm", psm}
	cmd := exec.Command(ocr, args...)
	cmd.Stdout = os.Stdout
	cmd.Stderr = os.Stderr
	err = cmd.Run()

	if err != nil {
		logrus.Errorf("cmd.Run (%s %s) error : %v\n", processedPath, strings.Join(args, " "), err)
		return output, err
	}

	outputByte, err := ioutil.ReadFile(outputPath2)
	if err != nil {
		logrus.Errorf("ioutil.ReadFile(%s) error : %v\n", outputPath, err)
		return output, err
	}
	output = strings.TrimSpace(string(outputByte))

	return output, nil
}
