package cmd

import (
	"github.com/zellyn/kooky/chrome"
	"log"
	"net/http"
	"os"
	"path/filepath"
	"strings"
)

// @title    LoadChromeCookies
// @description    从本地chrome路径加载指定domain的cookies
// @param    domain string 需要提起cookie的domain
// @return

func LoadChromeCookies(domain string) ([]*http.Cookie, error) {

	var cookies []*http.Cookie
	cookiesName := "Cookies"
	userHomeDir, _ := os.UserHomeDir()
	defaultPath := "AppData/Local/Google/Chrome/User Data/Default/"
	cookiesFile := filepath.Join(userHomeDir, defaultPath, cookiesName)
	exist, _ := FileExists(cookiesFile)
	if exist == false {
		cookiesFile = filepath.Join(userHomeDir, defaultPath, "Network", cookiesName)
	}
	println(cookiesFile)
	chromeCookies, err := chrome.ReadCookies(cookiesFile)
	if err != nil {
		log.Printf("ReadCookies error : %v\n", err)
		return cookies, err
	}
	for _, cookie := range chromeCookies {
		if strings.Contains(cookie.Domain, domain) == true {
			//fmt.Println(cookie)
			cookies = append(cookies, &http.Cookie{
				Name:    cookie.Name,
				Value:   cookie.Value,
				Path:    cookie.Path,
				Domain:  cookie.Domain,
				Expires: cookie.Expires,
			})
		}
	}
	return cookies, nil
}

// @title    LoadChromeCookiesVer1
// @description    从本地chrome路径加载指定domain的cookies
// @param    domain string 需要提起cookie的domain
// @return

func LoadChromeCookiesVer1(domain, cookiesPath string) ([]*http.Cookie, error) {

	var cookies []*http.Cookie

	chromeCookies, err := chrome.ReadCookies(cookiesPath)
	if err != nil {
		log.Printf("ReadCookies error : %v\n", err)
		return cookies, err
	}
	for _, cookie := range chromeCookies {
		if strings.Contains(cookie.Domain, domain) == true {
			//fmt.Println(cookie)
			cookies = append(cookies, &http.Cookie{
				Name:    cookie.Name,
				Value:   cookie.Value,
				Path:    cookie.Path,
				Domain:  cookie.Domain,
				Expires: cookie.Expires,
			})
		}
	}
	return cookies, nil
}
