package cmd

import "syscall"

// @title    GetWinUserName
// @description    获取windows当前登录用户名
// @param
// @return username string 用户名
func GetWinUserName() string {
	var size uint32 = 128
	var buffer = make([]uint16, size)
	user := syscall.StringToUTF16Ptr("USERNAME")

	//获取当前用户名
	syscall.GetEnvironmentVariable(user, &buffer[0], size)

	return syscall.UTF16ToString(buffer)
}
