package cmd

import (
	"fmt"
	"github.com/blinkbean/dingtalk"
	"log"
	"strings"
	"time"
)

// @title    SendMarkDownMsg
// @description     推送包含图片链接的makrdown信息到钉钉群
// @param
// @return

func SendMarkDownMsg(imgUrl, token, secret string) error {
	cli := dingtalk.InitDingTalkWithSecret(token, secret)
	title := fmt.Sprintf("看板%s", time.Now().Format("01/02 15:04"))
	err := cli.SendMarkDownMessage(title, fmt.Sprintf("![screenshot](%s)", imgUrl))
	if err != nil {
		log.Printf("SendLinkMessage error : %v\n", err)
		return err
	}
	return nil
}

// @title    Sendimgs
// @description     推送包含多张图片链接的makrdown信息到钉钉群
// @param imgUrls []string 多张图片url的slice
// @return

func Sendimgs(imgUrls []string, token, secret string) error {
	cli := dingtalk.InitDingTalkWithSecret(token, secret)
	title := fmt.Sprintf("看板%s", time.Now().Format("01/02 15:04"))
	content := []string{}
	for idx, imgUrl := range imgUrls {
		content = append(content, fmt.Sprintf("![screenshot%v](%s)\n", idx, imgUrl))
	}

	err := cli.SendMarkDownMessage(title, strings.Join(content, ""))
	if err != nil {
		log.Printf("SendLinkMessage error : %v\n", err)
		return err
	}

	return nil
}

// @title    Sendimgs,增加了title参数
// @description     推送包含多张图片链接的makrdown信息到钉钉群
// @param imgUrls []string 多张图片url的slice
// @return

func SendImgs(imgUrls []string, title, token, secret string) error {
	cli := dingtalk.InitDingTalkWithSecret(token, secret)
	content := []string{}
	for idx, imgUrl := range imgUrls {
		content = append(content, fmt.Sprintf("![screenshot%v](%s)\n", idx, imgUrl))
	}

	err := cli.SendMarkDownMessage(title, strings.Join(content, ""))
	if err != nil {
		log.Printf("SendLinkMessage error : %v\n", err)
		return err
	}

	return nil
}

// @title    SendTextMsg
// @description    推送文本信息到钉钉群
// @param
// @return

func SendTextMsg(content, token, secret string) error {
	cli := dingtalk.InitDingTalkWithSecret(token, secret)
	err := cli.SendTextMessage(content)
	if err != nil {
		log.Printf("SendTextMsg error : %v\n", err)
		return err
	}
	return nil
}
