package cmd

import (
	"bytes"
	"fmt"
	"os/exec"
)

// Wget 调用wget.exe下载,-t参数表示重试次数,-T参数表示超时等待时间,-w两次尝试之间间隔SECONDS秒,-O把文档写到FILE文件中
func Wget(url, localPath string) (err error) {
	cmd := exec.Command("wget.exe", url, "-t", "3", "-T", "25", "-w", "3", "-O", localPath, "--no-check-certificate")
	var stdout bytes.Buffer
	var stderr bytes.Buffer
	cmd.Stdout = &stdout
	cmd.Stderr = &stderr
	err = cmd.Run()
	if err != nil {

		fmt.Println(fmt.Sprint(err) + ": " + ConvertByte2String([]byte(stderr.String()), "GB18030"))
		return err
	}
	fmt.Println("Result: " + stdout.String())

	return
}
