package cmd

import (
	"bytes"
	"encoding/json"
	"io/ioutil"
	"log"
	"net/http"
	"net/http/cookiejar"
	"net/url"
	"time"
)

func PostJson(srcUrl string, params, headers map[string]string, data map[string]interface{}, cookies []*http.Cookie) (string, error) {
	var content string

	//解析原生的url
	parseUrl, _ := url.Parse(srcUrl)

	//new个cookiejar罐子
	jar, err := cookiejar.New(nil)

	if err != nil {
		log.Printf("cookiejar New error : %v\n", err)
		return content, err
	}
	//把传入的cookies装入罐
	jar.SetCookies(parseUrl, cookies)
	//处理jsondata
	byteData, err := json.Marshal(data)
	if err != nil {
		log.Printf("Marshal data error : %v", err)
		return content, err
	}

	//初始化请求,加入15秒timeout
	client := &http.Client{Jar: jar, Timeout: 15 * time.Second}
	req, _ := http.NewRequest("POST", srcUrl, bytes.NewReader(byteData))

	//处理query参数
	q := req.URL.Query()
	for k, v := range params {
		q.Add(k, v)
	}
	req.URL.RawQuery = q.Encode()

	//请求加入头部
	for k, v := range headers {
		req.Header.Add(k, v)
	}

	//发出请求
	resp, err := client.Do(req)

	if err != nil {
		log.Printf("client.Do error : %v\n", err)
		return content, err
	}

	//读取返回页面数据
	body, _ := ioutil.ReadAll(resp.Body)
	defer resp.Body.Close()
	content = string(body)

	return content, nil

}

// @title GetX
// @description 带参数,头部,cookie的get请求封装
// @param
// @return
func GetX(srcUrl, proxyUrl string, params, headers map[string]string, cookies []*http.Cookie) (string, error) {
	var content string

	//解析原生的url
	parseUrl, _ := url.Parse(srcUrl)

	//new个cookiejar罐子
	jar, err := cookiejar.New(nil)

	if err != nil {
		log.Printf("cookiejar New error : %v\n", err)
		return content, err
	}
	//把传入的cookies装入罐
	jar.SetCookies(parseUrl, cookies)

	transport := &http.Transport{}
	if len(proxyUrl) > 1 {
		proxyProxyUrl, _ := url.Parse(proxyUrl)
		transport.Proxy = http.ProxyURL(proxyProxyUrl)
	}
	//初始化请求,加入15秒timeout
	client := &http.Client{Jar: jar, Timeout: 15 * time.Second, Transport: transport}
	req, _ := http.NewRequest("GET", srcUrl, nil)

	//处理query参数
	q := req.URL.Query()
	for k, v := range params {
		q.Add(k, v)
	}
	req.URL.RawQuery = q.Encode()

	//请求加入头部
	for k, v := range headers {
		req.Header.Add(k, v)
	}

	//发出请求
	resp, err := client.Do(req)

	if err != nil {
		log.Printf("client.Do error : %v\n", err)
		return content, err
	}

	//读取返回页面数据
	body, _ := ioutil.ReadAll(resp.Body)
	defer resp.Body.Close()
	content = string(body)

	return content, nil
}

// GetContentWithCookies 带cookie获取源地址的内容
func GetContentWithCookies(srcUrl string, cookies []*http.Cookie) (string, error) {

	var content string

	//new个cookiejar罐子
	jar, err := cookiejar.New(nil)

	if err != nil {
		log.Printf("cookiejar New error : %v\n", err)
		return content, err
	}

	//原生的url
	parseUrl, _ := url.Parse(srcUrl)

	//把传入的cookies装入罐
	jar.SetCookies(parseUrl, cookies)

	//初始化请求
	client := &http.Client{Jar: jar, Timeout: 15 * time.Second}
	req, _ := http.NewRequest("GET", srcUrl, nil)

	//请求加入头部
	req.Header.Add("User-Agent", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/94.0.4606.81 Safari/537.36")

	//发出请求
	resp, err := client.Do(req)

	if err != nil {
		log.Printf("client.Do error : %v\n", err)
		return content, err
	}

	//读取返回页面数据
	body, _ := ioutil.ReadAll(resp.Body)
	defer resp.Body.Close()
	content = string(body)

	return content, nil
}
