package cmd

import (
	"github.com/koltyakov/gosip"
	"github.com/koltyakov/gosip/api"
	strategy "github.com/koltyakov/gosip/auth/saml"
	"io/ioutil"
	"log"
	"os"
	"path/filepath"
)

type SPConf struct {
	//ConfFilePath string          `json:"conf_file_path"` //sharepoint登录config文件路径
	SiteURL  string          `json:"site_url"`
	Username string          `json:"username"`
	Password string          `json:"password"`
	SPC      *gosip.SPClient `json:"spc"` //客户端认证连接对象
}

func (m *SPConf) GetAuthClient() error {
	// configPath := "private.spo-user.json"
	//为了安全,把siteurl等通过结构体传入参数
	auth := &strategy.AuthCnfg{
		SiteURL:  m.SiteURL,
		Username: m.Username,
		Password: m.Password,
	}
	//if err := auth.ReadConfig(m.ConfFilePath); err != nil {
	//	return fmt.Errorf("unable to get config: %v", err)
	//}
	m.SPC = &gosip.SPClient{AuthCnfg: auth}
	return nil
}

// @title    DownloadFileByRelativeURL
// @description    根据相对url下载
// @auth      ila 2021-11-10
// @param     relativeURL  sharepoint相对URL,targetPath 本地路径
// @return    error        是否成功
func (m *SPConf) DownloadFileByRelativeURL(relativeURL, targetPath string) error {

	// Getting auth params and client
	err := m.GetAuthClient()
	if err != nil {
		log.Fatalln(err)
	}

	// Binding SharePoint API
	sp := api.NewSP(m.SPC)

	data, err := sp.Web().GetFile(relativeURL).Download()
	if err != nil {
		log.Printf("Download file error : %v\n", err)
		return err
	}

	file, err := os.Create(filepath.Join(targetPath, filepath.Base(relativeURL)))
	if err != nil {
		log.Printf("unable to create a file: %v\n", err)
		return err
	}
	defer file.Close()
	_, err = file.Write(data)
	if err != nil {
		log.Printf("unable to write to file: %v\n", err)
		return err
	}
	file.Sync()

	return nil
}

// @title    UploadFile
// @description    上传本地文件到sharepoint服务器
// @auth      ila 2021-11-10
// @param     folder  sharepoint相对路径,filePath 本地文件完整路径,targetName 线上文件名
// @return    error        是否成功
func (m *SPConf) UploadFile(folder, filePath, targetName string) error {
	// Getting auth params and client
	err := m.GetAuthClient()
	if err != nil {
		log.Fatalln(err)
	}

	// Binding SharePoint API
	sp := api.NewSP(m.SPC)

	fdr := sp.Web().GetFolder(folder)

	content, err := ioutil.ReadFile(filePath)
	if err != nil {
		log.Printf("ReadFile error: %v\n", err)
		return err
	}

	fileAddResp, err := fdr.Files().Add(targetName, content, true) //是否覆盖
	if err != nil {
		log.Printf("NewFile upload error: %v\n", err)
		return err
	}

	log.Printf("New file URL : %s\n", fileAddResp.Data().ServerRelativeURL)

	return nil
}
