package cmd

import (
	"fmt"
	"github.com/tebeka/selenium"
	"log"
	"os"
	"path/filepath"
	"strings"
	"time"
)

// @title GetPBIScreenshots
// @description 遍历获取PBI页面,并截图
// @param PBIPageURL,PBI的首页
// @return
func (m *SeleniumDriverConf) GetPBIScreenshots(PBIPageURL, screenshotPath, fileNameNotExt string) (screenshotFileNames []string, err error) {

	err = m.WebDriver.Get(PBIPageURL)
	if err != nil {
		fmt.Printf("Get url error : %v\n", err)
		return
	}
	handle, _ := m.WebDriver.CurrentWindowHandle()
	m.WebDriver.ResizeWindow(handle, 1920, 1080)
	m.WebDriver.MaximizeWindow(handle)

	err = m.WebDriver.WaitWithTimeout(ShareExists, 30*time.Second)
	if err != nil {
		log.Printf("GetPBIScreenshots ShareExists error:%v", err)
		XWarning(fmt.Sprintf("GetPBIScreenshots ShareExists error:%v", err))
		return
	}

	// todo 判断加载完成,暂时sleep30秒
	time.Sleep(30 * time.Second)
	//首页
	data, err := m.WebDriver.Screenshot()
	if err != nil {
		log.Printf(" %s,Screenshot  error : %v\n", PBIPageURL, err)
		XWarning(fmt.Sprintf(" %s,Screenshot  error : %v", PBIPageURL, err))
		return
	}

	screenshotFileName := fmt.Sprintf("%v_0.png", fileNameNotExt)
	screenshotFilePath := filepath.Join(screenshotPath, screenshotFileName)
	ScreenshotSaveTo(data, screenshotFilePath)

	screenshotFileNames = append(screenshotFileNames, screenshotFileName)

	for i := 1; i < 999; i++ {
		log.Printf("page %v start===>", i+1)
		XWarning(fmt.Sprintf("page %v start===>", i+1))
		//判断是否有下一页,没有则跳出循环
		err = m.WebDriver.WaitWithTimeout(NextPageExists, 30*time.Second)
		if err != nil {
			log.Printf("GetPBIScreenshots NextPageExistsV2 error : %v\n", err)
			XWarning(fmt.Sprintf("GetPBIScreenshots NextPageExistsV2 error : %v", err))

			break

		}

		//判断是否刷新完
		//err = m.WebDriver.WaitWithTimeout(ShareExists, 30*time.Second)
		//if err != nil {
		//	return
		//}

		// todo 判断加载完成,暂时sleep30秒
		time.Sleep(30 * time.Second)

		//刷新完成,开始截图
		data, err = m.WebDriver.Screenshot()
		if err != nil {
			log.Printf(" page %v,Screenshot  error : %v\n", i, err)
			XWarning(fmt.Sprintf(" page %v,Screenshot  error : %v\n", i, err))
			break
		}

		screenshotFileName = fmt.Sprintf("%v_%v.png", fileNameNotExt, i)
		ScreenshotSaveTo(data, filepath.Join(screenshotPath, screenshotFileName))
		screenshotFileNames = append(screenshotFileNames, screenshotFileName)
	}

	return
}

// @title ScreenshotSaveTo
// @description  PBI页面截图另存为图片文件
// @param
// @return
func ScreenshotSaveTo(data []byte, screenshotFilePath string) error {

	//currentDir, _ := os.Getwd()
	//imgPath := filepath.Join(currentDir, cfg.DownloadFolderName, "pbi.png")
	f, err := os.Create(screenshotFilePath)
	if err != nil {
		log.Printf("%v, Create error : %v\n", screenshotFilePath, err)
		return err
	}
	f.Write(data)
	defer f.Close()

	return nil
}

// @title ShareExists
// @description 从分享按钮,判断页面是否完成刷新,2021-12-07更新了cssselector的元素
// @param
// @return
func ShareExists(driver selenium.WebDriver) (bool, error) {
	_, err := driver.FindElement(selenium.ByCSSSelector, "button[aria-label='共享']")
	if err != nil {
		return false, err
	}

	return true, nil

}

// @title NextPageExists
// @description 判断页面是否有下一页的按钮,并点击,2021-12-07更新了cssselector的元素
// @param
// @return
func NextPageExists(driver selenium.WebDriver) (bool, error) {
	elem, err := driver.FindElement(selenium.ByCSSSelector, "button[aria-label='下一页']")
	if err != nil {
		return false, err
	}
	elemi, err := elem.FindElement(selenium.ByCSSSelector, "i")
	if err != nil {
		return false, fmt.Errorf("找不到下一页button的标签i")
	}
	elemClass, err := elemi.GetAttribute("class")
	if err != nil {
		return false, fmt.Errorf("找不到下一页的class")
	}
	if strings.Contains(elemClass, " inactive") == true {
		return false, fmt.Errorf("下一页禁止点击")
	}
	//排除了其它情况,尝试点击下一页
	err = elem.Click()
	if err != nil {
		return false, err
	}
	return true, nil

}
