package cmd

import "os"

// @title    PathExists
// @description     判断文件夹是否存在
// @param    path string 文件夹路径
// @return

func PathExists(path string) (bool, error) {
	_, err := os.Stat(path)
	if err == nil {
		return true, nil
	}
	if os.IsNotExist(err) {
		return false, nil
	}
	return false, err
}
