package cmd

import (
	"syscall"
	"unsafe"
)

// @title    MsgBox
// @description    弹出提示框
// @param     title  提示框标题,content 提示框内容
// @return
func MsgBox(title, content string) {
	user32dll, _ := syscall.LoadLibrary("user32.dll")
	user32 := syscall.NewLazyDLL("user32.dll")
	MessageBoxW := user32.NewProc("MessageBoxW")
	MessageBoxW.Call(IntPtr(0), StrPtr(content), StrPtr(title), IntPtr(0))
	defer syscall.FreeLibrary(user32dll)

}

func IntPtr(n int) uintptr {
	return uintptr(n)
}

func StrPtr(s string) uintptr {
	return uintptr(unsafe.Pointer(syscall.StringToUTF16Ptr(s)))
}
