package cmd

import (
	"fmt"
	"golang.org/x/sys/windows/registry"
	"os"
	"path/filepath"
	"strconv"
	"strings"
)

func GetChromeExePath() (path string, err error) {
	key, err := registry.OpenKey(registry.LOCAL_MACHINE, "SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\App Paths\\chrome.exe\\", registry.READ)

	if err != nil {
		XWarning(fmt.Sprintf("GetChromeExePath OpenKey  error : %v\n", err))
		return
	}
	defer key.Close()

	path, _, err = key.GetStringValue("Path")
	if err != nil {
		XWarning(fmt.Sprintf("GetChromeExePath GetStringValue  error : %v\n", err))
		return
	}
	if path[len(path)-len("chrome.exe"):] != "chrome.exe" {
		path = filepath.Join(path, "chrome.exe")
	}

	return
}

// @title    GetChromeUserDataDir
// @description    获取windows当前用户的chrome用户目录
// @param
// @return chromeuserDataDir string

func GetChromeUserDataDir() string {
	userHome, _ := os.UserHomeDir()
	return filepath.Join(userHome, "/AppData/Local/Google/Chrome/User Data/Default")
}

// CheckChromeInstalled 检查是否安装了chrome
func CheckChromeInstalled() bool {
	key, err := registry.OpenKey(registry.CURRENT_USER, "Software\\Google\\Chrome", registry.READ)

	if err != nil {
		XWarning(fmt.Sprintf("CheckChromeInstalled OpenKey  error : %v\n", err))
		return false
	}
	if key != 0 {
		return true
	}
	//fmt.Printf("key=====>%v\n", key)
	return false
}

// GetChromeVersionFromRegedit 从注册表获取chrome的版本
func GetChromeVersionFromRegedit() int {
	ChromeVersion := 90
	key, err := registry.OpenKey(registry.CURRENT_USER, "Software\\Google\\Chrome\\BLBeacon", registry.READ)

	if err != nil {
		XWarning(fmt.Sprintf("GetChromeVersionFromRegedit OpenKey  error : %v\n", err))
		return ChromeVersion
	}
	defer key.Close()

	version, _, err := key.GetStringValue("version")
	if err != nil {
		XWarning(fmt.Sprintf("GetChromeVersionFromRegedit OpenKey  error : %v\n", err))
		return ChromeVersion
	}

	fmt.Printf("version======>%v\n", version)

	rets := strings.Split(version, ".")
	if len(rets) > 0 {
		ChromeVersion, _ = strconv.Atoi(rets[0])
	}
	fmt.Printf("ChromeVersion======>%v\n", ChromeVersion)
	return ChromeVersion
}
