package cmd

import (
	"fmt"
	"github.com/parnurzeal/gorequest"
	"net/http"
	"time"
)

func HTTPGet(url, proxy, param string, headers map[string]string, cookies []*http.Cookie) ([]byte, error) {
	s := gorequest.New().Get(url)

	//设置timeout
	s = s.Timeout(15 * time.Second)

	//添加proxy
	if len(proxy) > 3 {
		s = s.Proxy(proxy)
	}

	//添加headers
	for k, v := range headers {
		s = s.Set(k, v)
	}

	//传递query参数
	s = s.Send(param)

	//添加cookies
	s = s.AddCookies(cookies)

	resp, body, errs := s.EndBytes()
	if errs != nil || resp.StatusCode >= 300 {
		return body, fmt.Errorf("fail to request,error : %v\n", errs)
	}
	return body, nil
}
